	subroutine mvtsay(x,n,k,np,u1,u2,u3,ndf1,ndf2,pvaluee,pvaluec,
     +	pvaluef)
c
c***********************************************************************
c
c   FORTRAN subroutine to calculate the value of the test statistic
c   for the multivariate extension of Tsay's (1986) test for linearity
c   of a time series.
c
c   Input: x = a matrix of dimension n x k containing the multivariate
c              time series.
c          n = an integer containing the length of the time series (and
c              so the number of columns of x).
c          k = an integer containing the number of time series (and so
c              the number of rows of x).
c          np = an integer containing the order of the autoregressive
c               process.
c
c   Output: u = a double precision real scalar containing the value
c               of the test statistic.
c           ndf1 = an integer containing the numerator degrees of
c                  freedom.
c           ndf2 = an integer containing the denominator degrees of 
c                  freedom.
c           pvaluee = a double precision real scalar containing the
c                     p-value of the test statistic based on the exact
c                     distribution (a product of independent beta
c                     random variables.
c           pvaluec = a double precision real scalar containing the 
c                     p-value of the test statistic based on the chi-
c                     square approximation to the distribution.
c           pvaluef = a double precision real scalar containing the 
c                     p-value of the test statistic based on an F 
c                     distribution.  If p = 1 or 2 or if the number of
c                     non-linear terms in the non-linear model = 1 or
c                     2, the distribution is an exact F distribution.
c
c   Accuracy:  Implicit double precision (a-h,p-z)
c
c   Created: 7/19/97 Bonnie Ray
c   Modified: 7/24/97  Jane L. Harvill
c
c   Subprograms called: vech, udists, IMSL subroutines DRGIVN, IMSL
c                       double precision function DMACH
c
c***********************************************************************
c
	parameter(nkmx = 5, nmx = 500, npmx = 10, nqmx = (npmx*nkmx)**2)
	parameter (nsmx = nqmx + npmx*nkmx)
	implicit double precision (a-h, p-z)
c
	double precision x(nmx,nkmx),xr(nmx,nkmx+nsmx)
	double precision xr2(nmx,nkmx+nsmx),xmin(nsmx),xmin2(nsmx)
	double precision xmax(nsmx),xmax2(nsmx),xt1(npmx*nkmx)
	double precision xt1t(1,npmx*nkmx)   				
	double precision y(nqmx),yfit(nmx,nsmx),ssr(nkmx,nkmx)
	double precision b(nsmx,nsmx),b2(nsmx,nsmx),ssy(nkmx,nkmx)
	double precision r(nsmx,nsmx),r2(nsmx,nsmx)
	double precision d(nsmx),d2(nsmx),tstats(8),tempu(1)
	double precision sse(nkmx,nkmx),sse2(nsmx,nsmx)
	double precision tempx(nmx,nsmx),tempy(nmx,nkmx)
c
	integer inddep1(nkmx),inddep2(nsmx)
	integer indind(npmx*nkmx),indind2(nsmx)
c
	external vech, DRGIVN, DMACH, DGEMM, DLFTSF, DLFDSF
c
c   Initialize variables:
c
	ndf1 = 0
	ndf2 = 0
	u = 0.0d0
	pvaluee = 0.0d0
	pvaluec = 0.0d0
	pvaluef = 0.0d0
c
c
c   Set up the X matrix for the regressions in steps one and two of the
c   test.
c
c   xr contains "data matrix"; xr is [X_t|X_{t-1},...,X_{t-p}] is
c   used for the first regression and is [X_t|X_{t-1},...,X{t-p}|
c   X^2_{t-1},X_{t-1}X_{t-2},...,X_{n-p-1}X_{p-j}] (that is, the
c   first regression xr with all second-order and cross-product
c   terms following.
c
c   tempx contains the matrix of "independent" variables; that is,
c   tempx = [X_{t-1}, ... ,X_{t-p}].
c
c   xt1 = np+i-jth row of [X_{t-1},...,X_{t-p}]
c
c   xt1t = the transpose of xt1.
c
c	iz = the length of the half-stacking vector needed in step two
c
	iz = (np*k)*(np*k+1)/2
c
	do i = 1,n-np
		do j = 0,np
			do l = 1,k
				xr(i,k*j+l) = x(i+np-j,l)
		  	enddo
c
c   Form a vector of additional responses for step two regression:
c   xt1 is the p+i-j row of x for the first regression (of length
c   np*k).
c
			if(j.gt.0) then
				do l = 1,k
					tempx(i,k*(j-1)+l) = x(i+np-j,l)
					xt1(k*(j-1)+l) = x(i+np-j,l)
					xt1t(1,k*(j-1)+l) = xt1(k*(j-1)+l)
				enddo
			endif
		enddo
c
c   The subroutine vech multiplies the two matrices xt1*xt1t and
c   stacks all elements of that product on or below the main 
c   diagonal.  The result is returned in the vector y.
c
c   In this way the second-order and crossproduct terms for the
c   last columns of xr are created.  The following loop appends
c   those terms to xr.
c
		call vech(xt1,xt1t,npmx*nkmx,np*k,1,1,np*k,0,y)
c
		do l = 1,iz
			xr(i,k*np+k+l) = y(l)
		enddo
	enddo
c
c   Begin calculations for step one of multivariate extension of
c   Tsay's (1986) Original F test.
c
c   Perform k-variate AR(np) regression of x on xr.  IMSL subroutine
c   DRGIVN is used to perform calculations.
c
c   DRGIVN is a double precision IMSL subroutine used to fit a 
c   multivariate linear regression model via fast Givens transformation.
c
c   indind is a vector of indices required by DRGIVN.  indind contains
c   the column numbers of xr that are the independent variables.  
c   indind must be of length np*k.
c
c   inddep1 is a vector of indices required by DRGIVN.  inddep1 is of
c   length k containing the column numbers of xr that are the
c   dependent variables.
c
	do i = 1,np*k
		indind(i) = k+i
	enddo
	do i = 1,k
		inddep1(i) = i
	enddo
c
c   DRGIVN will return the following:
c    b = np*k x k matrix containing least squares solution.
c    r = np*k x np*k upper triangular matrix containing the "R" matrix
c        from a QR decomposition of the matrix of regressors.  Since the
c        first argument passed to DRGIVN has a value of 0, the matrix
c        of raw sums of squares and crossproducts for the regressors
c        can be found as r*t*diag(d)*r where diag(d) is the diagonal
c        matrix whose diagonal elements are the elements of the vector
c        d.
c     d = vector of length np*k containing scale factors for fast 
c         Givens transformations.  Since the first argument passed to 
c         DRGIVN has a value of 0, each element of d is 1.0d0.
c     irank = the rank of r.
c     dfe = degrees of freedom for error.
c     sse = k x k matrix containing residual sums of squares and
c           crossproducts.  sse(m,n) contains the current sums of
c           crossproducts of residuals for the mth and nth dependent
c           variables.
c     nrmiss = number of rows of data encountered that contained any
c              missing values.
c     xmin = a vector of length np*k containing the minimum values
c            for each of the regressors.
c     xmax = a vector of length np*k containing the maximum values 
c            for each of the regressors.
c
c    
c    
	call DRGIVN(0,n-np,k*(np+1)+iz,xr,nmx,0,np*k,indind,k,inddep1,
     +	0,0,0,100*DMACH(4),b,nsmx,r,nsmx,d,irank,dfe,sse,
     +	nkmx,nrmiss,xmin,xmax)
c
c  Compute residuals from linear k-variate AR regression and store 
c  in the vector xr2.
c
c  The IMSL subroutine DGEMM is used to performs these calculations.
c  DGEMM assigns the matrix yfit <- 1.0d0*tempx*b + 0.0d0*yfit.  The
c  first arguments passed to DGEMM indicate to not take the transpose
c  of tempx and b, respectively. The remaining arguments are defined
c  as follows:
c     n - np = number of columns of tempx
c     np*k = number of rows of tempx and number of columns of b.  
c     k = number of rows of b.
c     nmx = leading dimension of tempx.
c     npmx*nkmx = leading dimension of b.
c     nmx = leading dimension of yfit.
c
	call DGEMM('N','N',n-np,k,np*k,1.0d0,tempx,nmx,b,nsmx,0.0d0,
     +	yfit,nmx)
c
c   Compute the residuals for the first regression and sort them in
c   the matrix xr2 and tempy.  xr2 will eventually contain residuals
c   from regression 1 (in columns 1 though k) and regression 2 (in
c   columns k+1 through k+iz).
c
	do i = 1,n-np
	do j = 1,k
		xr2(i,j) = xr(i,j) - yfit(i,j)
		tempy(i,j) = xr2(i,j)
	enddo
	enddo

c	write(8,*) 'In MVTsay'
c	write(8,*) 'beta'
c	do i=1,k*np
c	   write(8,*) (b(i,j),j=1,k)
c      enddo
c	write(8,*) 'tempx'
c	do i=1,3
c	write(8,*) (tempx(i,j),j=1,k*np)
c	enddo
c	write(8,*) 'x'
c	do i=1,3
c	write(8,*) (xr(i,j),j=1,k )
c	enddo
c	write(8,*) 'yfit'
c	do i=1,3
c	write(8,*) (yfit(i,j),j=1,k)
c 	enddo
c	write(8,*) 'Res'
c	do i=1,3
c	write(8,*) (xr2(i,j),j=1,k+iz )
c	enddo
c
c   Perform regression two of second order terms on X_t.  Use only
c   third part of xr (second-order and crossproduct) for "dependent"
c   variables.
c
c   DRGIVN is used for this too.
c
	do i = 1,iz
		inddep2(i) = (np+1)*k + i
	enddo
c
	call DRGIVN(0,n-np,k+np*k+iz,xr,nmx,0,np*k,indind,iz,inddep2,
     +	0,0,0,100*DMACH(4),b,nsmx,r,nsmx,d,irank,dfe,sse2,
     +	nsmx,nrmiss,xmin,xmax)

c	 write(8,*) 'XR2'
c	 do i=1,3
c	  write(8,*) (xr2(i,j),j=1,k+iz)
c	 enddo
c
c   Compute residuals for the second regression and store them in the
c   matrix xr2:
c
c   DGEMM is used for this too.
c
	call DGEMM('N','N',n-np,iz,np*k,1.0d0,tempx,nmx,b,nsmx,
     +	0.0d0,yfit,nmx)
c
c	 write(8,*) 'XR2'
c	 do i=1,3
c	  write(8,*) (xr2(i,j),j=1,k+iz)
c	 enddo

	do i = 1,n-np
	do j = 1,iz
		xr2(i,k+j) = xr(i,k+np*k+j) - yfit(i,j)
c	       res2(i,j)=xr2(i,k+j)
	enddo
	enddo
c	write(8,*) 'beta'
c	do i=1,k*np
c	   write(8,*) (b(i,j),j=1,iz)
c      enddo
c	write(8,*) 'yfit'
c	do i=1,3
c	write(8,*) (yfit(i,j),j=1,iz)
c 	enddo
c	write(8,*) 'Res'
c	do i=1,3
c	write(8,*) (xr2(i,k+j),j=1,iz)
c	enddo
c
c   This is the end of the calculations for steps one and two of the
c   testing procedure.
c
c   Begin step three:  regression of residuals from first regression
c   (contained in the first k columns of xr2) on the residuals of
c   the second regression (contained in the k+1 through k+iz columns
c   of xr2).  The residuals from this final regression are calculated.
c
c   DRGIVN is invoked again.  In this call to DRGIVN, sse is the
c   k x k matrix containing the (regression 3) residual sums of squares
c   and cross-products.  The determinant of SSE = sse is used in the
c   denominator of the test statistic.
c
	do i = 1,iz
		indind2(i) = k+i
      enddo
c	 write(8,*) 'XR2'
c	 do i=1,3
c	  write(8,*) (xr2(i,j),j=1,k+iz)
c	 enddo
c
	call DRGIVN(0,n-np,iz+k,xr2,nmx,0,iz,indind2,k,inddep1,0,0,0,
     +	100*dmach(4),b2,nsmx,r2,nsmx,d2,irank,dfe,sse,nkmx,nrmiss,
     +	xmin2,xmax2)
c	 write(8,*) 'XR2'
c	 do i=1,3
c	  write(8,*) (xr2(i,j),j=1,k+iz)
c	 enddo

c     do j=1,k
c	 do i=1,n-np
c	   res1(i)=xr2(i,j)
c       enddo
c	 call DRLSE(n-np,res1,iz,res2,nmx,0,bx,sstx,ssex)
c	 write(8,*) 'sse: ',ssex
c	do i=1,iz
c	write(8,*) bx(i)
c	enddo
c	enddo
c
c      write(8,*) 'last regression'
c	do i=1,iz
c	  write(8,*) (b2(i,j),j=1,k)
c      enddo
c   This call to DMXTF multiplies the residuals from the first
c   regression by themselves to get total sum of squares for the
c   third regression.
c   
	call DMXTXF(n-np,k,tempy,nmx,k,ssy,nkmx)
c	write(8,*) 'SSE'
c	do i=1,k
c	  write(8,*) (sse(i,j),j=1,k)
c      enddo
c
c   Calculate matrix of sum of squared and crossproduct terms for 
c   regression using relationship SSY = SSReg + SSE.  The determinant
c   of ssr is used in the denominator of the test statistic.
c
	do i = 1,k
	do j = 1,k
		ssr(i,j) = ssy(i,j) - sse(i,j)
	enddo
	enddo
c
c
	ndf2 = (n -np)-((np*k)*(np*k+3))/2
	ndf1=iz
c	 Look at these to compare to results for SMTsay when debugging
c	f1 = (ssr(1,1)/dble(ndf1))/(sse(1,1)/dble(ndf2 ))
c	f2 = (ssr(2,2)/dble(ndf1))/(sse(2,2)/dble(ndf2))
      CALL DRHPTE(dble(ndf2),k,sse,nkmx,0,tempu,1,dble(ndf1),ssr, 
     +       nkmx,tstats)
      u1=tstats(1)
	u2=tstats(3)
	u3=tstats(4)
      pvaluee=tstats(5)
	pvaluec=tstats(7)
	pvaluef=tstats(8)

	return
	end